<?php
/*
  This formatter lets you format strings using LiteComment class.
  It requires litecomment.php to be placed in autoload/, you can download it from:
    http://proger.i-forge.net/LiteComment/czD

  You can also avoid autoloading both this formatter and LiteComment class by creating
  a directory in UverseWiki's root named "litecomment" and placing both files there
  and renaming this file (the comment of which you're currently reading) to base.php.

  This formatter allows both inline and block calls. It also accepts several parameters
  to be set for LiteComment class which you can see in $validLcOptions property.

  %%(litecomment antispam=js, keepFormatChar=0)
    Hello, *world*!
    Reach me at mail@somewhere.ru.
  %%
*/

class Ulitecomment_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;
  public $htmlTag = 'code';
  public $htmlClasses = array('format', 'format-litecomment');

  // true = static, false = instance field.
  static $validLcOptions = array('minHeadingLevel' => true, 'maxHeadingLevel' => true,
                                 'keepFormatChar' => false, 'antispam' => false, 'recursive' => false);
  public $lcOptions = array();

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);
    $props['hash'][] = 'lcOptions';
  }

  function Parse() {
    if ($format = $this->settings->format) {
      $this->isBlock = $format->blockExpected;
      $this->lcOptions = array_intersect_key($format->current['params'], self::$validLcOptions);
    } else {
      // absense of format chain means it's called directly as a markup, e.g. TryParsing(..., 'scripter')
      $this->isBlock = true;
    }

    $this->isBlock and $this->htmlTag = 'div';
  }

  function SelfToHtmlWith($html) {
    if (!class_exists('LiteComment')) {
      throw new EUverseWiki('%%LiteComment formatter expects LiteComment class to be defined.');
    }

    $lc = new LiteComment( self::QuoteHTML($this->raw, ENT_COMPAT) );
    foreach ($this->lcOptions as $name => $value) {
      switch ($name) {
      case 'antispam':    $lc->SetAntiSpamMode($value); break;
      case 'recursive':   $lc->recursive = (bool) $value; break;
      default:
        if (self::$validLcOptions[$name]) {
          LiteComment::$$name = $value;
        } else {
          $lc->$name = $value;
        }
      }
    }

    $prefix = "<span class=\"format-name\">LiteComment</span>";
    return parent::SelfToHtmlWith($prefix.$lc->FormatInHTML());
  }
}
